/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.ant.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CacheFingerprintTask
extends Task {
    private Vector<FileSet> filesets = new Vector();
    protected String buildPath;
    private boolean processJS = true;
    private boolean processIMG = true;
    private boolean processCSS = true;
    private boolean fingerprintIMG = true;
    private String[] staticServers = null;
    private int serverCount = 0;

    public void setBuildPath(String _buildPath) {
        this.buildPath = _buildPath;
    }

    public void setProcessJS(boolean _processJS) {
        this.processJS = _processJS;
    }

    public void setProcessIMG(boolean _fingerprintIMG) {
        this.processIMG = _fingerprintIMG;
    }

    public void setProcessCSS(boolean _processCSS) {
        this.processCSS = _processCSS;
    }

    public void setStaticServers(String _serverNames) {
        this.staticServers = _serverNames.replaceAll("\\s+|http:\\/\\/", "").split(",");
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    protected void validate() {
        if (this.filesets.size() < 1) {
            throw new BuildException("fileset not set");
        }
    }

    public void execute() {
        this.validate();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                try {
                    String line;
                    ArrayList<String> tempFile = new ArrayList<String>(200);
                    String srcFilename = includedFiles[i].replace('\\', '/');
                    srcFilename = srcFilename.substring(srcFilename.lastIndexOf("/") + 1);
                    File srcFile = new File(ds.getBasedir(), includedFiles[i]);
                    this.log("Scanning " + srcFilename);
                    FileInputStream srcInputStream = new FileInputStream(srcFile);
                    BufferedReader srcFileBuffer = new BufferedReader(new InputStreamReader(srcInputStream));
                    Pattern jsPattern = Pattern.compile("^\\s*<(?i:script)\\s+.*\\s+(?i:src)\\s*=\\s*\"([^\"]*)\".*$");
                    Pattern imgPattern = Pattern.compile("^\\s*<(?i:img)\\s+.*\\s+(?i:src)\\s*=\\s*\"([^\"]*)\".*$");
                    Pattern cssPattern = Pattern.compile("^\\s*<(?i:link)\\s+.*\\s+(?i:href)\\s*=\\s*\"([^\"]*)\".*$");
                    while ((line = srcFileBuffer.readLine()) != null) {
                        if (this.processJS) {
                            line = this.addFingerprint(jsPattern, line, true);
                        }
                        if (this.processIMG) {
                            line = this.addFingerprint(imgPattern, line, true);
                        }
                        if (this.processCSS) {
                            line = this.addFingerprint(cssPattern, line, true);
                        }
                        tempFile.add(line);
                    }
                    srcFileBuffer.close();
                    File destFile = new File(ds.getBasedir(), includedFiles[i]);
                    FileOutputStream destOutputStream = new FileOutputStream(destFile);
                    BufferedWriter destFileBuffer = new BufferedWriter(new OutputStreamWriter(destOutputStream));
                    for (int j = 0; j < tempFile.size(); ++j) {
                        destFileBuffer.write((String)tempFile.get(j));
                        destFileBuffer.newLine();
                    }
                    destFileBuffer.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String addFingerprint(Pattern _pattern, String _line, boolean _addServer) {
        Matcher matcher = _pattern.matcher(_line);
        if (matcher.matches()) {
            MatchResult res = matcher.toMatchResult();
            String refFilename = this.buildPath + res.group(1);
            File refFile = new File(refFilename);
            if (refFile.exists()) {
                String withFingerprint = res.group(1) + "?" + this.getChecksum(refFile);
                if (_addServer) {
                    withFingerprint = this.addServer(withFingerprint);
                }
                _line = _line.replaceFirst(res.group(1), withFingerprint);
                this.log("Added fingerprint: " + withFingerprint);
            } else {
                this.log("Referenced file not found : " + refFilename);
            }
        }
        return _line;
    }

    private String addServer(String _path) {
        if (this.staticServers != null) {
            String currentServer = this.staticServers[this.serverCount % this.staticServers.length];
            this.log("Server: " + currentServer);
            ++this.serverCount;
            _path = "http://" + currentServer + _path;
        }
        return _path;
    }

    private String getChecksum(File _srcFile) {
        try {
            CheckedInputStream cis = new CheckedInputStream(new FileInputStream(_srcFile), new CRC32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            Long checksum = cis.getChecksum().getValue();
            return checksum.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

