[[Documentation index]][1]

Overview
========

- [Introduction](#introduction)
- [Directory structure](#directory-structure)
- [Bundles](#bundles)
- [Database](#database)
  - [Migrations](#migrations)
  - [Data fixtures](#data-fixtures)
- [Assets and views](#assets-and-views)

Introduction
------------

**Claroline** is built on top of the Symfony framework (version 2.x). It also
relies on librairies and frameworks commonly associated with Symfony, such as
Doctrine and Twig. This documentation doesn't cover the usage of those
dependencies. If you have any trouble with them, please refer to their official
documentation :

- [Symfony][2]
- [Doctrine][3]
- [Twig][4]

Sections below, and more generally this documentation, are intended to
highlight differences between Claroline and the standard Symfony distribution,
as well as the particular technical choices that have been made so far.

Directory structure
-------------------

The organization of directories in Claroline is close to the Symfony standard,
and has the same meaning :

<pre>
root
|-- app
|-- bin
|-- files
|-- vendor
+-- web
</pre>


The *app* directory is again close to the standard one :

<pre>
app
|-- Resources
|-- build
|-- config
|-- dev
+-- logs
</pre>


You will notice two special directories :

- The *build* directory gathers configuration files for some of the quality
  insurance tools used in the project workflow (more on that below). It is also
  in this directory that the reports generated by those tools are written.
- The *dev* directory includes scripts intended to ease the development
  process.

The *app/config* directory also contains a special sub-directory named
*local* :

<pre>
app
+-- config
    +-- local
</pre>

This directory stores all the configuration files particular to a given
installation of the platform. There you will find the *parameters.yml* file, in
which some important platform parameters (like the database connection
parameters) are stored, as well as the *plugin* directory, where the plugins
are "recorded" for their integration to the kernel.

The *vendor* directory contains sources. This is were you will find the
claroline core its dependencies.

Bundles
-------

The bundles are structured in the same way than any Symfony bundle. Classicaly,
you will find in most of the bundles the usual *Controller*, *Entity*,
*Resources*, etc. directories.

Database
--------

Claroline use the Doctrine ORM for database interactions. It allows both a
simpler development process and a portability across the major RDBMS (see the
DBAL documentation for a list of [supported drivers][5]).

### Data fixtures

A useful feature is the ability to load automatically some data sets in
the database, whether to provide some demo samples with a bundle or to have
data to work with in an automatic test. In Claroline, this result is acheived
using the Doctrine [Data Fixtures][8] library. A fixture is simply a class
implementing a `load` method, to which an instance of the entity manager is
passed by Doctrine when the fixture is executed. In that method, you can
therefore use the manager to persist any needed data. Example :

```php

namespace Foo\BarBundle\DataFixtures;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\Persistence\ObjectManager;
use Foo\BarBundle\Entity\FooEntity;

class FooFixture extends AbstractFixture
{
    public function load(ObjectManager $manager)
    {
        $foo = new FooEntity();
        $foo->setName('bar');
        $manager->persist($foo);
        $manager->flush();
    }
}

```

The data fixtures loading is also part of the installation of every bundle in
Claroline. To benefit from this feature, simply put your fixture classes in
a *DataFixtures* directory :

<pre>
bundle
+-- DataFixtures
    +-- FooFixture.php
</pre>

Using those fixtures in a test requires to instantiate the fixture class and
provide its dependencies manually. This will be covered later in this
documentation.

Assets and views
----------------

Claroline uses a few client-side libraries. Some -- like JQuery and Bootstrap
-- are available in every page, while others -- like underscore.js or
backbone.js -- are used only in specific areas. All of them are gathered in an
bundle called [FrontEndBundle][9], which is included by default in the
platform. A javascript-compiled version of Twig, called [twigjs][10] is also
used whenever client-side templating is required.

[[Documentation index]][1]

[1]:  ../index.md
[2]:  http://symfony.com/doc/current/index.html
[3]:  http://docs.doctrine-project.org/projects/doctrine-orm/en/latest/index.html
[4]:  http://twig.sensiolabs.org/documentation
[5]:  http://docs.doctrine-project.org/projects/doctrine-dbal/en/latest/reference/configuration.html#driver
[6]:  http://docs.doctrine-project.org/en/2.0.x/reference/tools.html#database-schema-generation
[7]:  http://docs.doctrine-project.org/projects/doctrine-migrations/en/latest/toc.html
[8]:  https://github.com/doctrine/data-fixtures
[9]:  https://github.com/claroline/FrontEndBundle
[10]: http://jmsyst.com/libs/twig.js
