<?php

/*
 * Copyright 2011 Johannes M. Schmitt <schmittjoh@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace TwigJs;

class CompileRequest
{
    private $name;
    private $source;
    private $defines;

    public function __construct($name, $source, array $defines = array())
    {
        if (empty($name)) {
            throw new \InvalidArgumentException('$name cannot be empty.');
        }

        $this->name = $name;
        $this->source = $source;
        $this->defines = $defines;
    }

    public function getSource()
    {
        return $this->source;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getDefines()
    {
        return $this->defines;
    }
}
